{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 08.01.99 - 11:03:21 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMAVI, MMCstDlg, MMDIB, MMGauge, MMUtils;

type
  TForm1 = class(TForm)
    OpenDialog: TMMAVIOpenDialog;
    AVIFile: TMMAVIFile;
    btnLoad: TButton;
    btnExtract: TButton;
    Gauge: TMMGauge;
    procedure btnLoadClick(Sender: TObject);
    procedure btnExtractClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnLoadClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      { close a previous loaded file }
      AVIFile.CloseFile;

      { set the filename }
      AVIFile.FileName := OpenDialog.FileName;

      { open the file }
      AVIFile.OpenFile;

      { do we have a Video stream ? }
      btnExtract.Enabled := (AVIFile.TypedStreamCount[stVideo] > 0);
   end;
end;

procedure TForm1.btnExtractClick(Sender: TObject);
var
   i: integer;
   VideoWorker: TMMAVIVideoWorker;
   VideoStream: TMMAVIStream;
   Bitmap     : TBitmap;
   H          : HBitmap;
   Pal        : HPAlette;

begin
   { get the first video stream }
   VideoStream := AVIFile.TypedStreams[stVideo,0];

   { create a Video Worker to access the video stream }
   Bitmap := TBitmap.Create;
   VideoWorker := TMMAVIVideoWorker.Create(AVIFile.TypedStreams[stVideo,0]);
   try
      VideoWorker.BeginReading(nil);
      try
         Screen.Cursor  := crHourGlass;
         Gauge.MaxValue := VideoStream.Length;
         Gauge.Progress := 0;
         Gauge.Visible  := True;

         for i := 0 to VideoStream.Length-1 do
         begin
            DIB_DIBToBitmap(VideoWorker.DIB[i], H, Pal);
            Bitmap.Handle  := H;
            Bitmap.Palette := Pal;
            Bitmap.SaveToFile(CheckPath(ExtractFilePath(AVIFile.FileName),True)+'FRAME'+IntToStr(i)+'.BMP');

            Gauge.Progress := i;
         end;

      finally
         VideoWorker.EndReading;
         Gauge.Visible := False;
         Screen.Cursor := crDefault;
      end;

   finally
      VideoWorker.Free;
      Bitmap.Free;
   end;
end;

end.
